"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var path_1 = require("path");
var os_1 = __importDefault(require("os"));
var contentFilteringServiceBinariesDirectory;
var sharedLibPath;
if (os_1.default.type() === "Linux") {
    // Do nothing on Linux
    throw new Error("Unsupported OS found: " + os_1.default.type());
}
else if (os_1.default.type() === "Darwin") {
    sharedLibPath = path_1.resolve(__dirname, "../native/libs/libcontent-filtering-lib.dylib");
}
else if (os_1.default.type() === "Windows_NT") {
    if (os_1.default.arch() === "x64") {
        sharedLibPath = path_1.resolve(__dirname, "../native/libs/x64/Release/WebFilteringClient.dll");
        contentFilteringServiceBinariesDirectory = path_1.resolve(__dirname, "../native/apps/WebFilteringService/x64/Release");
    }
    else {
        sharedLibPath = path_1.resolve(__dirname, "../native/libs/x32/Release/WebFilteringClient.dll");
        contentFilteringServiceBinariesDirectory = path_1.resolve(__dirname, "../native/apps/WebFilteringService/x32/Release");
    }
}
else
    throw new Error("Unsupported OS found: " + os_1.default.type());
var sharedLib = {
    path: sharedLibPath,
    initSymbol: "wt_content_filtering_initialize",
    executeCommandsSymbol: "wt_content_filtering_execute_commands",
};
exports.default = {
    sharedLib: sharedLib,
    contentFilteringServiceBinariesDirectory: contentFilteringServiceBinariesDirectory,
};
